const raNoticeWindow = {
    supportsMacOS13OrLater: false,
    
    /**
     * Set OS-specific information for all pages
    */
    setSupportsMacOS13OrLater (flag) { 
        this.supportsMacOS13OrLater = (flag == "true") 
    },
    
    /**
     * Sets the app tagline in templates.
     * @param (string) tagline - the tagline of the app
    */
    setAppName(appName) {
        let containers = document.querySelectorAll('.template-app-name');
        containers.forEach( c => {
            c.innerText = appName;
        });
    },

    /**
     * Sets the app icon in templates.
     * @param (string) appIcon - base64 png representation of the application icon
     * @param (string) appRetinaIcon - base64 png representation of the retina version of the application icon
    */
    setAppIcon(appIcon, appRetinaIcon) {
        var containers = document.querySelectorAll('.template-app-icon');
        containers.forEach(function(c){
            c.setAttribute('src', 'data:image/png;base64,' + appIcon);
            c.setAttribute('srcset', 'data:image/png;base64,' + appRetinaIcon + ' 2x');
        });
    },

    /**
     * Adds a class to the body tag.
     * @param (string) className - the class to add.
    */
    addBodyClass(className) {
        document.body.classList.add(className);
    },

    /**
     * Sets OS version information for the unsupportedOS pages.
     * @param (string) appVersion - the current application version.
     * @param (string) osVersion  - the current OS version.
    */
    setVersionInfo(appVersion, osVersion) {
        document.querySelectorAll('.appVersion').forEach(function f(e){
            e.innerText = appVersion;
        });
        document.querySelectorAll('.currentOSVersion').forEach(function f(e){
            e.innerText = osVersion;
        });
    },

    /**
    * Called internally to send click messages back to PTNoticeWindow
    */
    sendClickedMessage(id) {
        let msg = '{"type": "html-click", "id": "' + id + '"}';
        if(window.webkit.messageHandlers.PTNoticeWindow) {
            window.webkit.messageHandlers.PTNoticeWindow.postMessage(msg);
        }
    }

}

// Hook up the window click listener so all hyperlink and button clicks are routed back to
// PTNoticeWindow.
window.addEventListener("load", () => {
    document.querySelectorAll("a, button").forEach( e => {
        e.addEventListener("click", function(){ 
            raNoticeWindow.sendClickedMessage(this.id); 
        });
    });
});

document.addEventListener("keydown", (e) => {
    if(e.keyCode === 13) {
        e.preventDefault();

        let defaultButton = document.querySelector('.button.default');
        if(defaultButton) {
            defaultButton.click();
        }
    }
});
